<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use JLGR\EmailCollector\Enums\Status;

return new class extends Migration
{

    /**
     * Run the migrations.
     */
    public function up () : void
    {
        Schema::create('collected_emails', function (Blueprint $table) {
            $table->id();
            $table->enum('status', [
                Status::New->value,
                Status::Ignored->value,
                Status::Duplicate->value,
                Status::Processed->value,
            ])->default(Status::New->value);
            $table->string('name');
            $table->string('email');
            $table->text('message')->nullable();
            $table->boolean('archived')->default(FALSE);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down () : void
    {
        Schema::dropIfExists('collected_emails');
    }

};
