<?php

namespace JLGR\DataReports\Tasks;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use JLGR\DataReports\Enums\Status;
use JLGR\DataReports\Models\DataReport;

/**
 * Store data report in the local database.
 */
class StoreDataReport
{

	/**
	 * Handle the task.
	 * 
	 * @param  Model  $model
	 * @param  array  $data
	 * 
	 * @return DataReport
	 */
	public function handle (Model $model, array $data) : DataReport
	{
		return DataReport::create([
			'user_id' => Auth::id(),
			'reportable_id' => $model->id,
			'reportable_type' => get_class($model),
			'data' => json_encode($data['fields']),
			'status' => Status::New->value,
			'priority' => $data['priority'] ?? 'normal',
			'notes' => $data['notes'] ?? null,
		]);
	}
	
}
