<?php

namespace JLGR\DataReports\Tasks;

use JLGR\DataReports\Jobs\SendDataReportNotification;
use JLGR\DataReports\Models\DataReport;

/**
 * Notify admin with a new data report.
 */
class NotifyAdmin
{

	/**
	 * Handle the task.
	 * 
	 * @param  DataReport  $dataReport
	 * 
	 * @return void
	 */
	public function handle (DataReport $dataReport) : void
	{
		SendDataReportNotification::dispatch($dataReport->id);
	}
	
}
