<?php

namespace JLGR\DataReports\Support;

use InvalidArgumentException;

class DataReportTypeMapper
{

	/**
	 * Resolve configuration for a given data report type.
	 *
	 * @param  string  $type
	 * 
	 * @return array{collection: string, form: class-string}
	 */
	public static function resolve (string $type) : array
	{
		$types = config('jlgr.data-reports.types');

		if (! isset($types[$type])) {
			throw new InvalidArgumentException("Unknown data report type: {$type}");
		}

		return $types[$type];
	}

}
