<?php

namespace JLGR\DataReports\Services;

use Illuminate\Database\Eloquent\Model;
use JLGR\DataReports\Tasks\NotifyAdmin;
use JLGR\DataReports\Tasks\StoreDataReport;

class DataReportService
{

	/**
	 * Construct service.
	 * 
	 * @param  NotifyAdminHandler  $notifyAdminHandler
	 * @param  StoreDataReportHandler  $storeDataReportHandler
	 */
	public function __construct (
		protected NotifyAdmin $notifyAdmin,
		protected StoreDataReport $storeDataReport
	) {}

	/**
	 * Upload a media file using the correct handler.
	 *
	 * @param  Model  $model
	 * @param  array  $data
	 * 
	 * @return void
	 */
	public function createDataReport (Model $model, array $data) : void
	{
        $dataReport = $this->storeDataReport->handle($model, $data);
		
		$this->notifyAdmin->handle($dataReport);
	}

}
