<?php

namespace JLGR\DataReports\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use JLGR\Kernel\Models\BaseModel;

class DataReport extends BaseModel
{
	
	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'data_reports';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * Get the user that sent this invitation.
	 */
	public function user () : BelongsTo
	{
		return $this->belongsTo(config('jlgr.data-reports.user_model'));
	}

    /**
     * Get the parent reportable model (airport or entity).
     */
    public function reportable () : MorphTo
    {
        return $this->morphTo();
    }

}
