<?php

namespace JLGR\DataReports\Livewire;

use Filament\Actions\Contracts\HasActions;
use Filament\Actions\Concerns\InteractsWithActions;
use Filament\Schemas\Schema;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Illuminate\Database\Eloquent\Model;
use InvalidArgumentException;
use JLGR\DataReports\Services\DataReportService;
use JLGR\DataReports\Support\DataReportTypeMapper;
use Livewire\Component;

class DataReportForm extends Component implements HasForms, HasActions
{
	use InteractsWithActions;
    use InteractsWithForms;

	/**
	 * The model to attach uploaded media to.
	 */
	public Model $model;

	/**
	 * Upload context.
	 */
	public array $context;

	/**
	 * Form state.
	 */
	public array $data = [];

	/**
	 * Mount the component.
	 * 
	 * @param  array  $context
	 */
	public function mount (array $context) : void
	{
		if (!isset($context) || !is_array($context)) {
			throw new InvalidArgumentException('The $context property is required and must be an array.');
		}

		$this->context = $context;

		$this->data = [
			'fields' => $this->model->toArray(),
			'priority' => 'normal',
		];
	}
	
	/**
     * Form builder.
     *
     * @param Schema $schema
     *
     * @return Schema
     */
    public function form (Schema $schema) : Schema
	{
        $config = DataReportTypeMapper::resolve($this->context['type']);

        $formBuilderClass = $config['form'];

        return $formBuilderClass::make($schema, $this->context);
	}
	
	/**
	 * Process form.
	 * 
	 * @param  DataReportService  $service
	 * 
	 * @return void
	 */
	public function processForm (DataReportService $service) : void
	{
		$this->form->validate();
		
		$service->createDataReport(
			model: $this->model,
			data: $this->data
		);

		$this->dispatch('data-issue-reported', type: $this->context['type']);
	}

	/**
	 * Render the view.
	 */
	public function render ()
	{
		return view('data-reports::livewire.data-report-form.default');
	}

}
