<?php

namespace JLGR\DataReports\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendDataReportNotification implements ShouldQueue
{
	use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

	/**
	 * Create a new job instance.
	 * 
	 * @param  integer  $dataIssueReportId
	 * 
	 * @return void
	 */
	public function __construct (
		protected int $dataIssueReportId
	) {
		$this->onQueue('system');
	}

	/**
	 * Execute the job.
	 * Will be processed on the worker server.
	 * 
	 * @return void
	 */
	public function handle () : void {}

}
