<?php

namespace JLGR\DataReports\Forms;

use Filament\Schemas\Schema;
use Filament\Schemas\Components\Grid;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\TextInput;
use AviatorsEcho\Filament\Components\LocationPicker;
use AviatorsEcho\Models\Country;
use AviatorsEcho\Enums\AirportType;
use Filament\Forms\Components;
use Illuminate\Support\HtmlString;

class EntityFormBuilder
{

	/**
     * Form definition.
     *
     * @param Schema $schema
     *
     * @return Schema
     */
    public static function make (Schema $schema) : Schema
	{
		return $schema
			->components([
				Grid::make(12)
					->schema([
						Select::make('priority')
							->columnSpan(4)
							->label(__('Priority'))
							->options([
								'normal' => __('Normal priority'),
								'low' => __('Low priority'),
								'medium' => __('Medium priority'),
								'high' => __('High priority'),
							])
							->required()
							->default('normal'),
						Textarea::make('notes')
							->label(__('Additional notes'))
							->columnSpanFull(),
					]),
				Grid::make(12)
					->schema([
						Placeholder::make('form-info')
							->hiddenLabel()
							->columnSpanFull()
							->content(new HtmlString('<h3 class="text-lg mt-6">Use the fields below to edit this organisation\'s data.</h3>'))
					]),
				Grid::make(12)
					->schema([
						TextInput::make('fields.name')
							->label(__('Organisation name'))
							->columnSpanFull()
							->required()
							->autofocus(),
					]),
				Grid::make(12)
					->schema([
						LocationPicker::make('fields.location')
							->columnSpanFull()
							->label(__('Select the location on the map by clicking the right spot')),
					]),
				Grid::make(12)
					->schema([
						Grid::make(12)
							->schema([
								TextInput::make('fields.address')
									->columnSpan(8)
									->label(__('Address')),
								TextInput::make('fields.address_2')
									->columnSpan(8)
									->label(__('Extra address information')),
							]),
						Grid::make(12)
							->schema([
								TextInput::make('fields.postcode')
									->columnSpan(3)
									->label(__('Postcode')),
								TextInput::make('fields.city')
									->columnSpan(5)
									->label(__('City')),
								Select::make('fields.country_id')
									->columnSpan(8)
									->label(__('Country'))
									->options(self::getCountries())
									->searchable()
									->required(),
							]),
						Grid::make(12)
							->schema([
								TextInput::make('fields.website')
									->columnSpanFull()
									->label(__('Website'))
									->prefix('https://'),
							]),
						Grid::make(12)
							->schema([
								TextInput::make('fields.wikipedia')
									->columnSpanFull()
									->label(__('Wikipedia'))
									->prefix('https://'),
							]),
						Grid::make(12)
							->schema([
								TextInput::make('fields.linkedin')
									->columnSpanFull()
									->label(__('Linkedin'))
									->prefix('https://'),
							]),
						Grid::make(12)
							->schema([
								TextInput::make('fields.facebook')
									->columnSpanFull()
									->label(__('Facebook'))
									->prefix('https://'),
							]),
						Grid::make(12)
							->schema([
								TextInput::make('fields.instagram')
									->columnSpanFull()
									->label(__('Instagram'))
									->prefix('https://'),
							]),
					]),

			])
			->statePath('data');
	}

	/**
	 * Get all countries.
	 * 
	 * @return array
	 */
	protected static function getCountries ()
	{
		return Country::query()
			->orderBy('name', 'asc')
			->get()
			->pluck('name', 'id');
	}

}
