<?php

namespace JLGR\DataReports\Forms;

use Filament\Schemas\Schema;
use Filament\Schemas\Components\Grid;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Placeholder;
use Filament\Forms\Components\TextInput;
use AviatorsEcho\Filament\Components\LocationPicker;
use AviatorsEcho\Models\Country;
use AviatorsEcho\Enums\AirportType;
use Filament\Forms\Components;
use Illuminate\Support\HtmlString;

class AirportFormBuilder
{

	/**
     * Form definition.
     *
     * @param Schema $schema
     *
     * @return Schema
     */
    public static function make (Schema $schema) : Schema
	{
		return $schema
			->components([
				Grid::make(12)
					->schema([
						Select::make('priority')
							->columnSpan(4)
							->label(__('Priority'))
							->options([
								'normal' => __('Normal priority'),
								'low' => __('Low priority'),
								'medium' => __('Medium priority'),
								'high' => __('High priority'),
							])
							->required()
							->default('normal'),
						Textarea::make('notes')
							->label(__('Additional notes'))
							->columnSpanFull(),
					]),
				Grid::make(12)
					->schema([
						Placeholder::make('form-info')
							->hiddenLabel()
							->columnSpanFull()
							->content(new HtmlString('<h3 class="text-lg mt-6">Use the fields below to edit this airport\'s data.</h3>'))
					]),
				Grid::make(12)
					->schema([
						TextInput::make('fields.name')
							->label(__('Airport name'))
							->columnSpanFull()
							->required()
							->autofocus(),
					]),
				Grid::make(12)
					->schema([
						Select::make('fields.airport_type')
							->columnSpan(4)
							->label(__('Airport type'))
							->options(AirportType::class)
							->required(),
					]),
				Grid::make(12)
					->schema([
						TextInput::make('fields.municipality')
							->columnSpan(4)
							->label(__('Municipality'))
							->required(),
						Select::make('fields.country_id')
							->columnSpan(4)
							->label(__('Country'))
							->options(self::getCountries())
							->searchable()
							->required(),
					]),
				Grid::make(12)
					->schema([
						LocationPicker::make('fields.location')
							->columnSpanFull()
							->label(__('Select the location on the map by clicking the right spot')),
					]),
				Grid::make(12)
					->schema([
						Grid::make(12)
							->schema([
								TextInput::make('fields.icao')
									->columnSpan(3)
									->label(__('ICAO-code')),
									TextInput::make('fields.iata')
									->columnSpan(3)
									->label(__('IATA-code')),
							]),
						Grid::make(12)
							->schema([
								TextInput::make('fields.elevation')
									->columnSpan(3)
									->label(__('Field elevation'))
									->suffix('ft.'),
							]),
						Grid::make(12)
							->schema([
								TextInput::make('fields.website')
									->columnSpanFull()
									->label(__('Website'))
									->prefix('https://'),
							]),
						Grid::make(12)
							->schema([
								TextInput::make('fields.wikipedia')
									->columnSpanFull()
									->label(__('Wikipedia'))
									->prefix('https://'),
							])
					]),

			])
			->statePath('data');
	}

	/**
	 * Get all countries.
	 * 
	 * @return array
	 */
	protected static function getCountries ()
	{
		return Country::query()
			->orderBy('name', 'asc')
			->get()
			->pluck('name', 'id');
	}

}
