<?php

namespace JLGR\DataReports\Enums;

enum Status : string
{

	case New           = 'new';

	/**
	 * Get the corresponding label.
	 *
	 * @return string
	 */
	public function getLabel () : string
	{
		return match ($this) {
			self::New           => __('New'),
		};
	}

	/**
	 * Get the corresponding status color.
	 *
	 * @return string
	 */
	public function getColor () : string
	{
		return match ($this) {
			self::New           => 'sky-600',
		};
	}
	
	/**
	 * Find the enum case by the category key.
	 *
	 * @param  string  $key
	 * 
	 * @return self|null
	 */
	public static function fromKey (string $key) : ?self
	{
		return self::tryFrom($key);
	}

}
