<?php

namespace JLGR\DataReports;

use JLGR\DataReports\Livewire\DataReportForm;
use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

class DataReportsServiceProvider extends ServiceProvider
{
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		$this->mergeConfigFile();
	}

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		$this->publishConfigFile();
		$this->publishMigrations();
		
		$this->loadViewsFrom(__DIR__ . '/../resources/views', 'data-reports');

		$this->registerLivewireComponents();
	}

	/**
	 * Load custom routes.
	 *
	 * @return void
	 */
	protected function registerLivewireComponents ()
	{
		Livewire::component('data-reports::data-report-form', DataReportForm::class);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/data-reports.php' => config_path('jlgr/data-reports.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/data-reports.php',
			'jlgr.data-reports'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

}
