<?php

namespace JLGR\DataReports\DTOs;

class DataReportContext
{

	/**
	 * DTO attributes.
	 */
	public function __construct(
		public string $type,
		public string $returnUrl,
	) {}

	/**
	 * Convert DTO to an array.
	 * 
	 * @param  array  $data
	 * 
	 * @return self
	 */
    public function toArray () : array
    {
        return [
            'type' => $this->type,
            'returnUrl' => $this->returnUrl,
        ];
    }

	/**
	 * Populate DTO from the given array.
	 * 
	 * @param  array  $data
	 * 
	 * @return self
	 */
    public static function fromArray (array $data) : self
    {
        return new self(
            type: $data['type'],
            returnUrl: $data['returnUrl'],
        );
    }

}
