<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

	/**
	 * Run the migrations.
	 */
	public function up () : void
	{
		Schema::create('data_reports', function (Blueprint $table) {
			$table->id();
			$table->foreignId('user_id')->constrained()->onDelete('cascade');
			$table->enum('status', [
				'new',
				'in-process',
				'on-hold',
				'completed',
				'cancelled',
			])->default('new');
			$table->morphs('reportable');
			$table->string('category')->nullable();
			$table->enum('priority', [
				'low',
				'normal',
				'high',
				'urgent',
			])->default('normal');
			$table->json('data')->nullable();
			$table->text('notes')->nullable();
			$table->text('internal_notes')->nullable();
			$table->boolean('archived')->default(FALSE);
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down () : void
	{
		Schema::dropIfExists('data_reports');
	}

};
