<?php

return [

    /*
    |--------------------------------------------------------------------------
    | User Model
    |--------------------------------------------------------------------------
    |
    | Define the user model used to associate comments.
    |
    */

    'user_model' => \App\Models\User::class,

    /*
    |--------------------------------------------------------------------------
    | Reporting categories.
    |--------------------------------------------------------------------------
    |
    | Get form builders, etc.
    |
    */
	'types' => [

		'airports' => [
			'form' => \JLGR\DataReports\Forms\AirportFormBuilder::class,
		],

		'entities' => [
			'form' => \JLGR\DataReports\Forms\EntityFormBuilder::class,
		],

	],

    /*
    |--------------------------------------------------------------------------
    | Routes
    |--------------------------------------------------------------------------
    |
    | Routes used to redirect the user to after submitting a data report.
    |
    */

	'routes' => [
		'airport' => 'member.explore.airports.report-issue',
		'entity' => 'member.explore.entities.report-issue',
	],

	/*
	|--------------------------------------------------------------------------
	| Caching
	|--------------------------------------------------------------------------
	|
	| When enabled, the comments will be cached using the defined tags.
	|
	*/

	'cache' => [

		// Indicates whether caching is enabled.
		'enabled' => env('CACHING_ENABLED', true),

		// Default cache tags.
		'tag' => 'data-reports',

	],

	/*
	|--------------------------------------------------------------------------
	| Styling
	|--------------------------------------------------------------------------
	|
	| Html identifiers for form and table styling.
	|
	*/
	'css' => [

		// Form id selector.
		'form-selector' => 'data-form',

		// Table id selector.
		'form-selector' => 'data-table',
	],
	
];
