@php
	// Determine current nesting depth (0 = top-level)
	$depth = $comment->depth();
@endphp

<div class="flex {{ $depth > 0 ? 'mt-6' : '' }}">

	{{-- AVATAR --}}
	<div class="mr-4 shrink-0">
		@include('comments::livewire.comments-list.partials.user-avatar', [ 'user' => $comment->user ])
	</div>

	{{-- COMMENT BODY --}}
	<div class="flex-1">
		<h4 class="text-sm font-semibold text-gray-800">
			{{ $comment->user->name }}
			<span class="ml-2 text-sm font-normal text-gray-500">{{ $comment->created_at->diffForHumans() }}</span>
		</h4>

		<p class="mt-1 text-sm text-slate-700 whitespace-pre-line">
			{!! nl2br(e($comment->body)) !!}
		</p>

		@if (!$onlyTopLevel)
			<div class="mt-2 flex items-center space-x-2 divide-x">

				{{-- REPLY BUTTON (only on depth 0 and 1) --}}
				@if(auth()->check() && $depth < 2)
					<div class="flex">
						<button
							wire:click="$set('replyTo', {{ $comment->id }})"
							type="button"
							class="text-xs text-blue-600 hover:underline"
						>
							{{ __('Reply') }}
						</button>
					</div>
				@endif
				
				@if ($comment->children->isNotEmpty())
					<div class="flex pl-2">
						<button
							wire:click="toggleReplies({{ $comment->id }})"
							class="text-xs text-blue-600 hover:underline"
							type="button"
						>
							{{ 
								($expandedReplies[$comment->id] ?? false)
									? __('Hide replies')
									: __('Show :count replies', [ 'count' => $comment->children->count() ])
							}}
						</button>
					</div>
				@endif

				{{-- REPORT BUTTON --}}
				@auth
					@unless ($comment->user_id === auth()->id())
						<div class="flex pl-2">
							@if (! $comment->isReportedBy(auth()->user()))
								<button
									wire:click="toggleReport({{ $comment->id }})"
									class="text-xs text-red-700 hover:underline"
									type="button"
								>
									{{ __('Report') }}
								</button>
							@else
								<span class="text-xs text-gray-400 italic">
									{{ __('Reported') }}
								</span>
							@endif
						</div>
					@endunless
				@endauth
			</div>
		@endif

		{{-- INLINE REPLY FORM --}}
		@if ($replyTo === $comment->id && $depth < 2)
			<div class="mt-4">
				<livewire:comments::comment-form
					:commentable="$comment->commentable"
					:parent-id="$comment->id"
					:rows="2"
					wire:key="reply-form-{{ $comment->id }}"
				/>
			</div>
		@endif
				
		{{-- INLINE REPORT COMMENT FORM --}}
		@if ($reportingComment === $comment->id)
			<div class="mt-2 p-3 bg-red-50 border border-red-200 rounded text-sm text-red-800 space-y-2">
				<p>
					{{ __('Please only report comments that violate the guidelines. Misuse of the report function may lead to account restrictions.') }}
				</p>
				<div class="mt-2 flex items-center space-x-2 divide-x">
					<div class="flex">
						<button
							wire:click="report({{ $comment->id }})"
							class="text-xs font-semibold text-red-700 hover:underline"
						>
							{{ __('Report comment') }}
						</button>
					</div>
					<div class="flex pl-2">
						<button
							wire:click="toggleReport({{ $comment->id }})"
							class="text-xs text-gray-600 hover:underline"
						>
							{{ __('Cancel') }}
						</button>
					</div>
				</div>
			</div>
		@endif

		{{-- RECURSIVE CHILDREN WITH COLLAPSIBLE TOGGLE --}}
		@if (!$onlyTopLevel && $comment->children->isNotEmpty())
			@if ($expandedReplies[$comment->id] ?? false)
				<div class="mt-4">
					<div class="pl-6 border-l border-gray-200 space-y-6">
						@foreach ($comment->children as $child)
							@include('comments::livewire.comments-list.partials.comment', [ 'comment' => $child ])
						@endforeach
					</div>
				</div>
			@endif
		@endif
	</div>
</div>
