<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up ()
    {
        Schema::create('comment_statistics', function (Blueprint $table) {
            $table->id();
            $table->morphs('commentable');
            $table->unsignedInteger('count_toplevel')->default(0);
            $table->unsignedInteger('count_total')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down ()
    {
        Schema::dropIfExists('comment_statistics');
    }

};
