<?php

namespace JLGR\Comments\Models;

use Illuminate\Database\Eloquent\Relations\MorphTo;
use JLGR\Kernel\Models\BaseModel;

class CommentStatistic extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'comment_statistics';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * Get the parent likeable model (flight, etc).
	 */
	public function commentable () : MorphTo
	{
		return $this->morphTo();
	}

}
