<?php

namespace JLGR\Comments\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CommentReport extends Model
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'comment_reports';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * Boot the model.
	 */
	protected static function booted () : void
	{
		static::created(function (CommentReport $report): void {
			$comment = $report->comment;

			if (! $comment->manually_approved && $comment->reportCount() >= 3) {
				$comment->update([ 'approved_at' => null ]);
			}
		});
	}

	/**
	 * Get the comment that was reported.
	 */
	public function comment () : BelongsTo
	{
		return $this->belongsTo(Comment::class);
	}

	/**
	 * Get the user who submitted the report.
	 */
	public function user () : BelongsTo
	{
		return $this->belongsTo(config('jlgr.comments.user_model'));
	}

}
