<?php

namespace JLGR\Comments;

use JLGR\Comments\Contracts\ReportsComment;
use JLGR\Comments\Actions\ReportComment;
use JLGR\Comments\Contracts\SubmitsComment;
use JLGR\Comments\Actions\SubmitComment;
use JLGR\ReleaseNotes\Repositories\ReleaseNoteRepository;
use Illuminate\Support\ServiceProvider;
use JLGR\Comments\Actions;
use JLGR\Comments\Contracts;
use JLGR\Comments\Livewire as LivewireComponents;
use Livewire\Livewire;

class CommentsServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// Publish the package's configuration file.
		$this->publishConfigFile();

		// // Publish the package's migration file.
		$this->publishMigrations();
		
		// // Load views.
		$this->loadViewsFrom(__DIR__ . '/../resources/views', 'comments');

		// // Register Livewire components.
		$this->registerLivewireComponents();
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// // Register package repository.
		// $this->registerRepository();

		// // Merge config file.
		$this->mergeConfigFile();

		// Register action bindings.
		$this->registerActionBindings();
	}

	/**
	 * Register action bindings.
	 * 
	 * @return void
	 */
	protected function registerActionBindings ()
	{
		$this->app->singleton(ReportsComment::class, ReportComment::class);
		$this->app->singleton(SubmitsComment::class, SubmitComment::class);
	}

	/**
	 * Load custom routes.
	 *
	 * @return void
	 */
	protected function registerLivewireComponents ()
	{
		Livewire::component('comments::comment-form', LivewireComponents\CommentForm::class);
		Livewire::component('comments::comments-list', LivewireComponents\CommentsList::class);
	}

	/**
	 * Register the bug report repository.
	 * 
	 * @return void
	 */
	protected function registerRepository () : void
	{
		$this->app->bind(
			ReleaseNoteRepository::class,
			fn ($app) => new ReleaseNoteRepository
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/comments.php' => config_path('jlgr/comments.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/comments.php',
			'jlgr.comments'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

}
