<?php

namespace JLGR\Comments\Actions;

use Illuminate\Support\Facades\Auth;
use JLGR\Comments\Contracts\ReportsComment;
use JLGR\Comments\Models\Comment;
use JLGR\Comments\Models\CommentReport;

class ReportComment implements ReportsComment
{

	/**
	 * Report comment.
	 *
	 * @param  integer  $commentId
	 * 
	 * @return void
	 */
	public function handle (int $commentId) : void
	{
		$comment = Comment::find($commentId);

		if (!$comment || $comment->user_id === Auth::user()->id) {
			return;
		}

		CommentReport::firstOrCreate([
			'comment_id' => $commentId,
			'user_id' => Auth::user()->id,
		]);
	}

}
