<?php

namespace JLGR\Checkins\Models;

use Illuminate\Database\Eloquent\Relations\MorphTo;
use JLGR\Kernel\Models\BaseModel;

class CheckinStatistic extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'checkin_statistics';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * Get the parent checkinable model (museum, etc).
	 */
	public function checkinable () : MorphTo
	{
		return $this->morphTo();
	}

}
