<?php

namespace JLGR\Checkins\Models;

use Illuminate\Database\Eloquent\Relations\{ BelongsTo, MorphTo };
use JLGR\Kernel\Models\BaseModel;

class Checkin extends BaseModel
{

	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'checkins';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * Get the attributes that should be cast.
	 *
	 * @return array<string, string>
	 */
	protected function casts () : array
	{
		return [
			'date' => 'date',
		];
	}

	/**
	 * Get the parent checkinable model (museum, etc).
	 */
	public function checkinable () : MorphTo
	{
		return $this->morphTo();
	}

	/**
	 * Get the user that owns the like.
	 */
	public function user () : BelongsTo
	{
		return $this->belongsTo(config('jlgr.checkins.user_model'));
    }

}
