<?php

namespace JLGR\Checkins\Livewire;

use Filament\Actions\Contracts\HasActions;
use Filament\Actions\Concerns\InteractsWithActions;
use Filament\Schemas\Schema;
use Filament\Forms\Components\DatePicker;
use Filament\Forms\Components;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Illuminate\Support\Carbon;
use JLGR\Checkins\Contracts\CreatesCheckin;
use Livewire\Component;

class CheckinForm extends Component implements HasForms, HasActions
{
	use InteractsWithActions;
    use InteractsWithForms;

	/**
	 * The checkinable model.
	 * 
	 * @var mixed
	 */
	public mixed $checkinable;

	/**
	 * The form's state.
	 * 
	 * @var array
	 */
	public ?array $data = [];

	/**
	 * Component properties.
	 * 
	 * @var mixed
	 */
	public string $template = 'default';

	/**
	 * Mount the component with the checkinable model.
	 * 
	 * @param  mixed  $checkinable
	 */
	public function mount (mixed $checkinable) : void
	{
		$this->checkinable = $checkinable;

		$this->form->fill([
			'date' => Carbon::now()
		]);
	}
	
	/**
     * Build the form.
     *
     * @param \Filament\Forms\Form
     *
     * @return Schema
     */
    public function form (Schema $schema) : Schema
	{
		return $schema
			->components([
				DatePicker::make('date')
					->hiddenLabel()
					->required()
					->columnSpanFull(),
			])
			->statePath('data');
	}

	/**
	 * Submit the form and create the checkin.
	 * 
	 * @param  CreatesCheckin  $checkinProcessor
	 * 
	 * @return void
	 */
	public function processForm (CreatesCheckin $checkinProcessor) : void
	{
		$this->validate();

		$checkinProcessor->handle($this->checkinable, $this->data);

		$this->reset('data');
		$this->form->fill(); 	// Clear fields.

		$this->dispatch('checked-in');
	}

	/**
	 * Render the component.
	 */
	public function render ()
	{
		return view("checkins::livewire.checkin-form.{$this->template}");
	}

}
