<?php

namespace JLGR\Checkins\Livewire;

use Illuminate\Database\Eloquent\Collection;
use Livewire\Component;
use Illuminate\Database\Eloquent\Model;
use Livewire\Attributes\Computed;
use Livewire\Attributes\On;

class Checkin extends Component
{
	
	/**
	 * The checkinable model.
	 */
	public Model $checkinable;

    /**
     * Maximum number of checkins to display. If null, all checkins
	 * will be shown.
     *
     * @var int|null
     */
    public ?int $limit = null;

    /**
     * Flag indicating the checkin form should be visible.
     *
     * @var boolean
     */
    public bool $showCheckinForm = false;

    /**
     * Flag indicating the checkins list should be visible.
     *
     * @var boolean
     */
    public bool $showCheckinsList = false;

	/**
	 * Component properties.
	 * 
	 * @var mixed
	 */
	public string $template = 'default';

	/**
	 * Mount the component.
	 */
	public function mount (Model $checkinable) : void
	{
		$this->checkinable = $checkinable;
	}

	/**
	 * Load all top-level checkins.
	 */
	#[ On('checked-in') ]
	public function refresh () : void
	{
		$this->dispatch('$refresh');

		$this->showCheckinForm = false;
	}

	/**
	 * Render the component.
	 */
	public function render ()
	{
		return view("checkins::livewire.checkin.{$this->template}");
	}

}
