<?php

namespace JLGR\Checkins;

use JLGR\Checkins\Contracts\CreatesCheckin;
use JLGR\Checkins\Actions\CreateCheckin;
use Illuminate\Support\ServiceProvider;
use JLGR\Checkins\Actions;
use JLGR\Checkins\Contracts;
use JLGR\Checkins\Livewire as LivewireComponents;
use Livewire\Livewire;

class CheckinsServiceProvider extends ServiceProvider
{

	/**
	 * Bootstrap services.
	 *
	 * @return void
	 */
	public function boot ()
	{
		// // Publish the package's configuration file.
		$this->publishConfigFile();

		// // Publish the package's migration file.
		$this->publishMigrations();
		
		// // Load views.
		$this->loadViewsFrom(__DIR__ . '/../resources/views', 'checkins');

		// // Register Livewire components.
		$this->registerLivewireComponents();
	}
	
	/**
	 * Register services.
	 *
	 * @return void
	 */
	public function register ()
	{
		// // Register package repository.
		// $this->registerRepository();

		// // Merge config file.
		$this->mergeConfigFile();

		// Register action bindings.
		$this->registerActionBindings();
	}

	/**
	 * Register action bindings.
	 * 
	 * @return void
	 */
	protected function registerActionBindings ()
	{
		$this->app->singleton(CreatesCheckin::class, CreateCheckin::class);
	}

	/**
	 * Load custom routes.
	 *
	 * @return void
	 */
	protected function registerLivewireComponents ()
	{
		Livewire::component('checkins::checkin', LivewireComponents\Checkin::class);
		Livewire::component('checkins::checkin-form', LivewireComponents\CheckinForm::class);
		Livewire::component('checkins::checkins-list', LivewireComponents\CheckinsList::class);
	}

	/**
	 * Register the bug report repository.
	 * 
	 * @return void
	 */
	protected function registerRepository () : void
	{
		// $this->app->bind(
		// 	\JLGR\ReleaseNotes\Repositories\ReleaseNoteRepository::class,
		// 	fn ($app) => new \JLGR\ReleaseNotes\Repositories\ReleaseNoteRepository
		// );
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishConfigFile () : void
	{
		$this->publishes([
			__DIR__.'/../config/checkins.php' => config_path('jlgr/checkins.php'),
		], 'jlgr-config');
	}

	/**
	 * Merge the package's configuration file.
	 * 
	 * @return void
	 */
	protected function mergeConfigFile () : void
	{
		$this->mergeConfigFrom(
			__DIR__ . '/../config/checkins.php',
			'jlgr.checkins'
		);
	}

	/**
	 * Publish the package's configuration file.
	 * 
	 * @return void
	 */
	protected function publishMigrations () : void
	{
		$this->publishes([
			__DIR__.'/../database/migrations' => database_path('migrations'),
		], 'jlgr-migrations');
	}

}
