<?php

namespace JLGR\Checkins\Actions;

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use JLGR\Checkins\Contracts\CreatesCheckin;
use JLGR\Checkins\Models\Checkin;

class CreateCheckin implements CreatesCheckin
{

	/**
	 * Create new checkin.
	 *
	 * @param  mixed  $checkinable
	 * @param  array  $data
	 * 
	 * @return void
	 */
	public function handle (mixed $checkinable, array $data) : void
	{
		$userId = Auth::id();
		$isUnique = false;
		
		// Check if this is the first checkin for the user.
		if ($userId && !$checkinable->checkins()->where('user_id', $userId)->exists()) {
			$isUnique = true;
		}

		$checkin = Checkin::firstOrCreate([
			'user_id' => $userId,
			'checkinable_type' => get_class($checkinable),
			'checkinable_id' => $checkinable->id,
			'date' => $data['date'] ?? Carbon::now()->toDateString(),
		]);

		if ($checkin->wasRecentlyCreated) {
			$checkinable->updateCheckinStatistics(
				totalDelta: +1,
				uniqueDelta: $isUnique ? +1 : 0
			);
		}
	}

}
