<div>

	{{-- CHECKIN INFORMATION CURRENT USER --}}
	@unless ($showCheckinForm)
		@if ($checkinable->checkins->count())
			<p class="text-slate-700 text-sm">
				{!!
					__('You\'ve been here <span class="font-medium">:numberOfCheckins times</span>.', [
						'numberOfCheckins' => $checkinable->checkinsByCurrentUserCount(),
					])
				!!}
				<button wire:click="$toggle('showCheckinsList')" class="text-yellow-600 hover:text-yellow-700">
					{{ $showCheckinsList ? __('Hide check-ins') : __('Show check-ins') }}
				</button>.
			</p>
			<div class="mt-4">
				<x-filament::button wire:click="$toggle('showCheckinForm')" size="xs">
					{{ __('I\'ve been here again!') }}
				</x-filament::button>
			</div>
		@else
			<p class="text-slate-700 text-sm">
				{{ __('This place seems new to you. Would you like to check in?') }}
			</p>
			<div class="mt-4">
				<x-filament::button wire:click="$toggle('showCheckinForm')" size="xs">
					{{ __('Yes, I\'ve been here') }}
				</x-filament::button>
			</div>
		@endif
	@endunless

	{{-- CHECKIN FORM --}}
	@if ($showCheckinForm === true)
		<livewire:checkins::checkin-form :checkinable="$checkinable" wire:key="checkin-form-{{ $checkinable->id }}" template="inline" />
		<div class="mt-1">
			<button wire:click="$toggle('showCheckinForm')" class="text-yellow-600 hover:text-yellow-700 text-sm">
				{{ __('Cancel') }}
			</button>
		</div>
	@endif

	{{-- RECENT CHECKINS --}}
	@if ($showCheckinsList && !$showCheckinForm)
		<div class="mt-4">
			<livewire:checkins::checkins-list :checkinable="$checkinable" :limit="5" wire:key="checkin-list-{{ $checkinable->id }}" />
		</div>
	@endif

</div>
