<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up ()
    {
        Schema::create('checkin_statistics', function (Blueprint $table) {
			$table->id();
            $table->morphs('checkinable');
            $table->unsignedInteger('count_unique')->default(0);
            $table->unsignedInteger('count_total')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down ()
    {
        Schema::dropIfExists('checkin_statistics');
    }

};
