<?php

namespace JLGR\BugReports\Repositories;

use JLGR\BugReports\Queries\AllBugReports;
use JLGR\BugReports\Enums\Status;
use JLGR\Kernel\Enums\CacheDuration;
use JLGR\Kernel\Repositories\BaseRepository;

class BugReportRepository extends BaseRepository
{

	/**
	 * Constructor.
	 */
	public function __construct ()
	{
		// Indicates whether caching is enabled.
		$this->useCaching = config('jlgr.bug-reports.cache.enabled');

		// Get default cache tags.
		$this->cacheTag = config('jlgr.bug-reports.cache.tag');
	}

	/**
	 * Get number of new bug reports.
	 * 
	 * @param  array  $params
	 * 
	 * @return int
	 */
	public function getNumberOfNewBugReports (array $params = []) : int
	{
		$params = array_merge($params, [ 'status' => Status::New ]);

		return $this->retrieveFromCache(
			cacheKey: "number-of-new-bug-reports",
			callback: fn () => AllBugReports::count($params),
			duration: CacheDuration::OneHour
		);
	}
	
}
