<?php

namespace JLGR\BugReports\Queries;

use Illuminate\Database\Eloquent\Builder;
use JLGR\BugReports\Enums\Status;
use JLGR\BugReports\Models\BugReport;
use JLGR\Kernel\Queries\Eloquent\BaseQuery;

class AllBugReports extends BaseQuery
{

	/**
	 * Build a query for all bug reports.
	 * 
	 * @param array $params Optional array with filter params.
	 * 
	 * @return Builder
	 */
	protected static function builder (array $params = []) : Builder
	{
		return static::newQuery(new BugReport)

			// Filter on published records.
			->when($params['status'] ?? false, fn (Builder $query, Status $status)
				=> $query
					->where('status', $status->value));
	}

}
