<?php

namespace JLGR\BugReports\Observers;

use Illuminate\Support\Facades\Cache;
use JLGR\BugReports\Models\BugReport;
use JLGR\BugReports\Jobs\SendBugReportNotification;

class BugReportObserver
{

	/**
	 * Handle the "created" event.
	 * 
	 * @param  \App\Packages\BugReports\Models\BugReport  $bugReport
	 */
	public function created (BugReport $bugReport)
	{
		$this->invalidateCache();

		// Send notification, id enabled.
		if (config('jlgr.bug-reports.notifications.enabled'))
		{
			// Dispatch job for sending the notification.
			SendBugReportNotification::dispatch($bugReport->id);
		}
	}

	/**
	 * Handle the "updated" event.
	 * 
	 * @param  \App\Packages\BugReports\Models\BugReport  $bugReport
	 */
	public function updated (BugReport $bugReport)
	{
		$this->invalidateCache();
	}

	/**
	 * Handle the "deleted" event.
	 * 
	 * @param  \App\Packages\BugReports\Models\BugReport  $bugReport
	 */
	public function deleted (BugReport $bugReport)
	{
		$this->invalidateCache();
	}

	/**
	 * Invalidate cache.
	 * 
	 * @return void
	 */
	private function invalidateCache () : void
	{
		Cache::tags(config('jlgr.bug-reports.cache.tag'))->flush();
	}

}
