<?php

namespace JLGR\BugReports\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendBugReportNotification implements ShouldQueue
{
	use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

	/**
	 * Bug report id.
	 * 
	 * @var integer
	 */
	protected $bugReportId;

	/**
	 * Create a new job instance.
	 * 
	 * @param  integer  $bugReportId
	 * 
	 * @return void
	 */
	public function __construct ($bugReportId)
	{
		$this->bugReportId = $bugReportId;

		$this->onQueue(config('jlgr.bug-reports.notifications.queue'));
	}

	/**
	 * Execute the job.
	 * 
	 * @return void
	 */
	public function handle () : void {}

}
