<?php

namespace JLGR\BugReports\Filament;

use Filament\Schemas\Schema;
use Filament\Schemas\Components\Grid;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\{ Components, Form };

class BugReportFormBuilder
{

	/**
     * Build edit form.
     *
     * @param Schema $schema
     *
     * @return Schema
     */
    public static function get (Schema $schema) : Schema
	{
		return $schema
			->components([
				Grid::make(12)
					->schema([
						TextInput::make('name')
							->label(__('Brief description (subject)'))
							->columnSpanFull()
							->required()
							->autofocus()
							->validationMessages([
								'required' => __('Subject is required.'),
							]),
						TextInput::make('url')
							->label(__('Page on which the bug occurred'))
							->helperText(__('You can copy the url from your browser\'s address bar.'))
							->columnSpanFull(),
						Textarea::make('description')
							->label(__('Describe the bug  in detail'))
							->columnSpanFull()
							->rows(5)
							->required()
							->validationMessages([
								'required' => __('Description is required.'),
							]),
						Textarea::make('reproduction')
							->label(__('Describe the steps to reproduce'))
							->columnSpanFull()
							->rows(5),
					]),
			])
			->statePath('data');
	}

}
