<?php

namespace JLGR\BugReports\Actions;

use JLGR\BugReports\Models\BugReport;
use JLGR\BugReports\Contracts\CreatesBugReport;
use Illuminate\Support\Facades\Auth;

class CreateBugReport implements CreatesBugReport
{

	/**
	 * Process report bug form and send the message to the admin.
	 *
	 * @param  array  $input
	 * 
	 * @return void
	 */
	public function createBugReport (array $input) : void
	{
		// Create bug report.
		$bugReport = BugReport::create([
			'user_id' => Auth::user()->id,
			'name' => $input['name'],
			'description' => $input['description'],
			'reproduction' => $input['reproduction'] ?? null,
			'url' => $input['url'] ?? null,
		]);		
	}

}
