<?php

namespace JLGR\BugReports\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class BugReport extends Model
{
	
	/**
	 * The table associated with the model.
	 * 
	 * @var string
	 */
	protected $table = 'bug_reports';

	/**
	 * The attributes that are protected from mass assignment.
	 *
	 * @var array<int, string>
	 */
	protected $guarded = [];

	/**
	 * The user that submitted this feature request.
	 */
	public function user () : BelongsTo
	{
		return $this->belongsTo(config('jlgr.bug-reports.user_model'));
	}

}
