<?php

namespace JLGR\BugReports\Livewire;

use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Livewire\Component;
use JLGR\BugReports\Contracts\CreatesBugReport;
use JLGR\BugReports\Filament\BugReportFormBuilder;

class BugReportForm extends Component implements HasForms
{
	use InteractsWithForms;

	/**
	 * The form's state.
	 * 
	 * @var array
	 */
	public ?array $data = [];

	/**
	 * Flag indicating the visibility of the message sent message.
	 */
	public $messageSent = false;
	
	/**
	 * Submit the form.
	 * 
	 * @return void
	 */
	public function submitForm (CreatesBugReport $processor) : void
	{
		$this->validate();

		$processor->createBugReport($this->data);

		$this->reset('data');
		$this->messageSent = true;
	}
	
	/**
	 * Form builder.
	 * 
	 * @param  \Filament\Forms\Form $form
	 * 
	 * @return \Filament\Forms\Form
	 */
	public function form (Form $form) : Form { return BugReportFormBuilder::get($form); }

	/**
	 * Render the view.
	 */
	public function render ()
	{
		return view('bug-reports::livewire.bug-report-form.default');
	}

}
