<?php

namespace JLGR\BugReports\Filament;

use Filament\Forms\{ Components, Form };

class BugReportFormBuilder
{

	/**
	 * Build edit form.
	 * 
	 * @param  Form  $form
	 * 
	 * @return Form
	 */
	public static function get (Form $form) : Form
	{
		return $form
			->schema([
				Components\Grid::make(12)
					->schema([
						Components\TextInput::make('name')
							->label(__('Brief description (subject)'))
							->columnSpanFull()
							->required()
							->autofocus()
							->validationMessages([
								'required' => __('Subject is required.'),
							]),
						Components\TextInput::make('url')
							->label(__('Page on which the bug occurred'))
							->helperText(__('You can copy the url from your browser\'s address bar.'))
							->columnSpanFull(),
						Components\Textarea::make('description')
							->label(__('Describe the bug  in detail'))
							->columnSpanFull()
							->rows(5)
							->required()
							->validationMessages([
								'required' => __('Description is required.'),
							]),
						Components\Textarea::make('reproduction')
							->label(__('Describe the steps to reproduce'))
							->columnSpanFull()
							->rows(5),
					]),
			])
			->statePath('data');
	}

}
