<?php

namespace JLGR\BugReports\Enums;

enum Status : string
{

	// Cases...
	case Confirmed      = 'confirmed';
	case New            = 'new';
	case OnHold       	= 'on-hold';
	case Pending        = 'pending';
	case Rejected       = 'rejected';
	case Resolved       = 'resolved';
	case Scheduled      = 'scheduled';

	/**
	 * Get the corresponding label.
	 *
	 * @return string
	 */
	public function getLabel () : string
	{
		return match ($this) {
			self::Confirmed		=> __('Confirmed'),
			self::New			=> __('New'),
			self::OnHold		=> __('On hold'),
			self::Pending		=> __('Pending'),
			self::Rejected 		=> __('Rejected'),
			self::Resolved 		=> __('Resolved'),
			self::Scheduled		=> __('Scheduled'),
		};
	}
	
}
