<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use JLGR\BugReports\Enums\Status;

return new class extends Migration
{

	/**
	 * Run the migrations.
	 */
	public function up () : void
	{
		Schema::create('bug_reports', function (Blueprint $table) {
			$table->id();
			$table->foreignId('user_id')->constrained()->cascadeOnDelete();
			$table->enum('status', [
				Status::New->value,
				Status::Pending->value,
				Status::Confirmed->value,
				Status::OnHold->value,
				Status::Scheduled->value,
				Status::Resolved->value,
				Status::Rejected->value,
			])->default(Status::New->value);
			$table->string('name');
			$table->text('description')->nullable();
			$table->text('reproduction')->nullable();
			$table->string('url')->nullable();
			$table->boolean('points_granted')->default(FALSE);
			$table->boolean('archived')->default(FALSE);
			$table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 */
	public function down () : void
	{
		Schema::dropIfExists('bug_reports');
	}

};
